<?
class csv2table {

   var $csvfile;
   var $csvfilepath;
   var $title;
   var $columnstoshow;
   var $filter;
   var $condition;
   var $value;
   var $bool;

   var $header, $tablewidth;
   var $backcolor, $frontcolor, $titlecolor, $titlerowcolor, $rowcolor1,$rowcolor2;
   var $fonttitlecolor,$fontrow1color, $fontrow2color;

  function csv2table($csvpath = "") {
      if($csvpath != "") {
          $this->csvfilepath = $csvpath;
      } else {
          $this->csvfilepath = "";
      }

      $this->header = 1;
      $this->tablewidth = "70%";

      $this->titlecolor = "#757575";
      $this->fonttitlecolor ="#ffffff";

      $this->rowcolor1 = "#B1455E";
      $this->rowcolor2 = "";

      $this->fontrow1color = "";
      $this->fontrow2color = "";

      $this->bool = false;
  }

  function set_header($val) {
      if(strcasecmp($val,"on") == 0)
          $this->header = 1;
      else
          $this->header = 0;
      return 0;
  }

  function set_headercolor($col1,$col2) {
      $this->titlecolor = $col1;
      $this->fonttitlecolor = $col2;
      return 0;
  }

  function set_bgcolor($col1,$col2) {
      $this->rowcolor1 = $col1;
      $this->rowcolor2 = $col2;
      return 0;
  }

  function set_fontcolor($col1,$col2) {
      $this->fontrow1color = $col1;
      $this->fontrow2color = $col2;
      return 0;
  }

  function set_tablewidth($width) {
      $this->tablewidth = $width;
      return 0;
  }

  function showtable($csvfile,$title,$columnstoshow = "",$filter="") {

      $this->csvfile = $this->csvfilepath.$csvfile;
      $this->title = $title;
      $this->filter = $filter;

      if($columnstoshow != "") {
          $this->columnstoshow = explode(";",$columnstoshow);
      } else {
          $this->columnstoshow = "";
      }

      if(!file_exists($this->csvfile)) {
          echo "<br><center><b>Warning: File not found!</b><br></center>";
          return;
      }

      echo "<center><font face=verdana color=$this->titlecolor size=2><b>$this->title</b></font></center>";
      echo "<table align=center cellpadding=2 cellspacing=0 width=$this->tablewidth>";

      if($this->header) {
          $this->backcolor = $this->titlecolor;
          $this->frontcolor = $this->fonttitlecolor;
      } else {
          $this->getcolorsettings();
      }

      $isfilter = $this->get_filters();
      $fp = fopen ($this->csvfile,"r");
      $count = 0;
      while ($data = fgetcsv ($fp, 1000, ";")) {
          if($count != 0 && $isfilter){
              // check to see if the data follows the filter specified.
              $val=true;
              $val = $this->check_filter($data);
              if(!$val) continue;
          }
          $fontstart = "<font face=verdana size=1 color=$this->frontcolor><b>";
          $fontend = "</b></font>";

          echo "<tr bgcolor=$this->backcolor>";
          $num = count ($data);
          for ($c=0; $c<$num; $c++) {
              // check if this column should be displayed or not.
              if($this->check_column($c)) {
                  echo "<td class=\"txt\">$data[$c]</td>";
              }
          }
          echo "</tr>";
          $this->getcolorsettings();
          $count++;
      }
    echo "</table>";
    fclose ($fp);
  }

  function get_filters() {
      if(isset($this->filter) && is_array($this->filter)) {
          foreach($this->filter as $fnum => $fval) {
              $fnum--;
              $list = explode(";",$fval);
              $this->condition[$fnum] = trim($list[0]);
              $this->value[$fnum] = trim($list[1]);
          }
          return true;
      }
      return false;
  }

  function check_filter($data) {

      $ret = true;

      foreach($this->filter as $f => $fnum) {
          $f--;
          $op = trim($this->condition[$f]);
          $val = trim($this->value[$f]);
          $d = trim($data[$f]);
          switch ($op) {
              case ">" :   if($d <= $val)  $ret= false;
                           break;
              case "<" :   if($d >= $val)  $ret= false;
                           break;
              case "=" :   if(is_string($d)) {
                              if(strcasecmp($d,$val) != 0) $ret = false;
                           } else {
                               if($d != $val) $ret= false;
                           }
                            break;
              case "!=" :  if(is_string($d)) {
                              if(strcasecmp($d,$val) == 0)
                                 $ret = false;
                           } else {
                               if($d != $val);
                                  else $ret= false;
                           }
                           break;
          }
       }
       return $ret;
  }

  function check_column($c) {
      if($this->columnstoshow == "")
        return true;

      foreach($this->columnstoshow as $cs) {
          $cs = trim($cs);
          if(($cs-1) == $c) return true;
      }
      return false;
  }

  function getcolorsettings() {
      if($this->bool) {
          $this->backcolor = $this->rowcolor1;
          $this->frontcolor= $this->fontrow1color;
          $this->bool = false;
      } else {
          $this->backcolor = $this->rowcolor2;
          $this->frontcolor= $this->fontrow2color;
          $this->bool = true;
      }
   }
}
?>