<?php

/**
 *  YAPIG (Yet another PHP Image Gallery) - Configuration File -
 *  
 *  This file contains all configurable options of YaPiG.
 * 
 *  Please read carefully the instructions and complete the config file. 
 *  Don't worry. It will take less than five minutes. Most of values are ok  
 *  by default.
 * 
 *  Admin must change admin login data ($USER and $PASSWORD vairables)
 * 
 * @package admin
 * @author NaTaSaB 
 * @link http://yapig.sf.net
 * @copyright Distributed under GPL License.
 */

/**
 * Admin Username
 * 
 * This is the name you have to introduce in the admin.php login form. You
 * must change default value.
 * 
 * @global string $USER
 * @name $USER
 *
 */

$USER='kravtex';

/**
 * Admin Password
 * 
 * This is the password you have to introduce in the admin.php login form.
 * You must change default value.
 *
 * @global string $PASSWORD
 * @name $PASSWORD
 */

$PASSWORD='credo';

/**
 * Use cookies or sessions
 * 
 * Set this variable to 'false' if you want to use sessions for 
 * authentification issues. Set it to 'true' if you want to use cookies.
 * 
 * By default false is ok. I recommend set it to true only if you
 * have "rare" problems with authentification as admin or in password
 * protected galleries in your server.
 *
 */

$USE_COOKIES=false;

/**
 * Site Title
 *
 * This title will appear in the gallery Index.
 * 
 * @global string $I_TITLE
 * @name $I_TITLE
 *
 */

$I_TITLE='Kp galria - YaPig';

/**
 * Website Start Page
 * This variable is to have a link to your home page. It can be a relative or
 * complete URI.
 *
 * @global string $HOME
 * @name $HOME
 */

$HOME='index.php';


/**
 * Base Directory
 *
 * Here is where you have to store your photos and images. Each gallery will
 * be in a different subdirectory of $BASE_DIR. It must be a relative
 * path from YaPiG's root directory. 
 * 
 * ATENTION!!!
 * 
 *       + You must run install.php if you modify this directory.
 *       + Must end with the character '/' 
 * 
 * @global string $BASE_DIR
 * @name $BASE_DIR
 */

$BASE_DIR='photos/'; if (basename($_SERVER['PHP_SELF'])=="galeria.php") $BASE_DIR='image_gallery/' . $BASE_DIR;

//////////////////////////////////////////////////////////////////////////////
// INTERFACE CONFIG
//////////////////////////////////////////////////////////////////////////////

/**
 * YaPiG Language 
 * 
 * YaPiG Interface is prepared to be shown in any language. You can see
 * a full list of supported languages and their country code identifier
 * in the doc file doc/translations.html . In this document you can find
 * information about how to translate YaPiG into your language.
 * Default value "en".
 *
 * @global string $LANG
 * @name $LANG
 * 
 */

$LANG="hu";


/**
 * Template dir
 *
 * This variable stores th name of the directory where the template
 * that is used by yapig is stored
 * 
 * If you want to create your own template, please read the documentation.
 * Default template location is 'template/default/'. Note: MUST end with '/' 
 * character.
 *
 * @global string $TEMPLATE_DIR
 * @name $TEMPLATE_DIR
 */

$TEMPLATE_DIR='template/default2/';

/**
 * Number of Colummns
 *
 * This Variable tells YaPiG how many columns of thumbnails per row must
 * display.
 *
 * @global integer $NUM_COLUMNS
 * @name $NUM_COLUMNS
 */

$NUM_COLUMNS=4;

/**
 * Number of files
 * 
 * This tells how many files has each page. 
 * Total images/page is NUM_COLUMS x NUM_FILES
 * 
 * If NUM_FILES=0 then only one page is shown.
 * 
 * @global integer $NUM_FILES
 * @name $NUM_FILES
 */

$NUM_FILES=0;

/*
 * Max Thumbnail Size
 *
 * Size of the thumbnails created by the script. In pixels. The bigger they are,
 * the slower will be loaded the gallery.
 *
 * Thumbnails are proportional to original image size, the biggest side of the picture
 * will be set by this variable.
 *
 */

$THUMB_SIZE=120;


/**
 * Maximun image size
 * 
 * if width or height sizes are bigger than this value, when showing image is
 * automatically resized, it will not be bigger than this size. 
 * 
 * This is done using a JavaScript, and user can zoom bigger,smaller or
 * see the original image. 
 * 
 * Set this value to 0 to avoid resizing. Pixel Units.
 *
 */

$MAX_IMG_SIZE=350;

/**
 * prefix of the thumbnail name
 *
 * The thumbnail name will be with this format:  $THUMB_PREFIX + image.jpg
 *
 * example:
 *   -> $THUB_PREFIX="t_"
 *   -> image name image.jpg
 * then the thumbnail name:   t_image.jpg
 *
 */
$THUMB_PREFIX='t_';

/*
 * Thumbnail JPEG Quality
 *
 * Range must be an ingeger between 1 and 100, where 100 is the best quality
 * and biggest filesize.
 */

$THUMB_QUALITY=75;


/**
 * Required fields in comments
 * 
 * When an user sends a comment about one image there are five fields.
 * This way you can choose witch are required.
 * 
 * For a complete customization you can modify your template files:
 * add_comment_form.php thanks_comment.php and print_comment.php
 * 
 * @name REQ_IN_COMMENTS
 * @global array REQ_IN_COMMENTS comment field required
 */

$REQ_IN_COMMENTS['title']=true;
$REQ_IN_COMMENTS['author']=true;
$REQ_IN_COMMENTS['email']=false;
$REQ_IN_COMMENTS['web']=false;
$REQ_IN_COMMENTS['comment']=true;


//##########################################################################

//Delete or comment with "//"  the line bellow once you have 
// configured this file.
// If not, YaPiG won't let you login as admin.
//$STOP=true;

?>
