<?php
/**
 *  YaPiG Installer.   
 * 
 * @package install
 */

require_once('config.php');
require_once('functions.php');
require_once('admin_func.php');
require_once('install_func.php');

/**
 * Creates a random seed from microtime. 
 * 
 * @returns float seed.
 */

function make_seed() {
        list($usec, $sec) = explode(' ', microtime());
        return (float) $sec + ((float) $usec * 100000);
}


/// MAIN PROGRAM //////////////////////////////////////

//Interface
include($TEMPLATE_DIR .'face_begin.php');

heading(_y("YaPiG Installation"));
print_main_menubar();

/*if (file_exists('$BASE_DIR . global-gen.php')){
    msg(_y("YaPiG already installed"));
}*/

if (0) {} //for debug
else { //Do installation
  
  //Try to load GD in case it is not already done.
  if (!load_gd()) {
    error(_y('Could not be loaded GD library witch is required by YapiG or your GD version is too old. Please read doc/install.html documentation for more information.'));
  }
  else {
    msg(_y("Nice! Your server has GD library. You can run YaPiG!"));
  }  
    
    //Now create a random name directory
    srand(make_seed());
    $randval = md5(rand() . rand());
    $SECURE_DIR="yapig_data." . $randval . "/";
    if (!mkdir($BASE_DIR . $SECURE_DIR ,0777))   
      error(_y("Could not create SECURE_DIR. Change your BASE_DIR (view config.php) permissions to 777."));

    //Create index files for avoiding server fancy index.
    if (!touch($BASE_DIR . $SECURE_DIR . "index.html"))
      error(_y("Could not create index.html in SECURE_DIR"));
    if (!touch($BASE_DIR . "index.html"))
      error(_y("Could not create index.html in BASE_DIR"));
    
  
  if (!($fd=@fopen($BASE_DIR . 'global-gen.php', 'w'))){
    msg(_y("Change YaPiG's root directory permissions to allow creating new files."));
	error(_y("Installation aborted. Could not create config file."));
	
  }
  fputs($fd,"<?php");
  $contents=<<<HEREDOC
    
    /****************************************************
     * Generated by YaPiG Installation. Do not modify   *
     ****************************************************/
      
    /**
     * Secure dir
     *    
     * This directory will store all dynamic information.
     *
     * 
     */  
      
     \$SECURE_DIR= \$BASE_DIR . "$SECURE_DIR"; 
    /**
     * gid-directory correspondence file.
     *
     * This file will store the correspondence between gid and dirs in
     * the common correspondence file format.Sample line:
     *    gid \$EQUAL value
     */
    
    \$GID_DIRS= \$SECURE_DIR . 'gid-dirs.dat';

    /* phid->filename Correspondence file.
     *
     * This file will have the correspondece beteen photo identificator phid
     * and image filename (just filename without path information).
     *
     * Will be stored in the common correspondence file format. Sample line:
     * phid $EQUAL phid_filename.ext
     *
     */
    
    \$PHID_FILENAMES='phid.$randval';
    
    
    
HEREDOC;
    fputs($fd,$contents);
    fputs($fd, '?>');

    heading(_y("YaPiG successfully installed."),3);


       heading(_y("Congratulations YAPIG is working!"),3);

//welcome message    
    echo _y('
   <p>Welcome to <a href="http://yapig.sf.net">YaPig.</a></p>
   <p>There are <strong>NO</strong> galleries.<p>
   <p>If this is the first time you run YaPiG:</p>
   <ol>
   <li>Edit the <i>config.php</i> file.</li>
   <li><a href="admin.php">Login as admin</a> and add a new gallery.</li>
   </ol>
    ');
   
        

}
    
include($TEMPLATE_DIR . 'face_end.php');

?>  
